/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.api.VWException;
import filenet.vw.integrator.adaptors.jms.VWParameterItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

public class VWEventItem {
    private String m_name = null;
    private String m_description = null;
    private Vector m_parameters = null;

    public VWEventItem(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public VWParameterItem createParameterItem(String name, int nType, boolean bIsArray) throws Exception {
        VWParameterItem paramItem = this.getParameterItem(name);
        if (paramItem != null) {
            throw new VWException("vw.integrator.parameterAlreadyExists", "A parameter with this name already exists.");
        }
        paramItem = new VWParameterItem(name, nType, bIsArray);
        if (this.m_parameters == null) {
            this.m_parameters = new Vector();
        }
        this.m_parameters.addElement(paramItem);
        return paramItem;
    }

    public VWParameterItem createParameterItem(VWParameterItem paramItem) throws Exception {
        VWParameterItem newParamItem = this.createParameterItem(paramItem.getName(), paramItem.getType(), paramItem.getIsArray());
        if (newParamItem != null) {
            newParamItem.setDescription(paramItem.getDescription());
        }
        return newParamItem;
    }

    public void deleteParameterItem(String name) {
        VWParameterItem paramItem = this.getParameterItem(name);
        if (paramItem != null) {
            this.m_parameters.removeElement(paramItem);
        }
    }

    public VWParameterItem getParameterItem(String name) {
        if (this.m_parameters != null) {
            for (int i = 0; i < this.m_parameters.size(); ++i) {
                VWParameterItem parameterItem = (VWParameterItem)this.m_parameters.elementAt(i);
                if (parameterItem == null || VWStringUtils.compare(parameterItem.getName(), name) != 0) continue;
                return parameterItem;
            }
        }
        return null;
    }

    public VWParameterItem[] getParameterItems() throws Exception {
        Object[] parameterItems = null;
        if (this.m_parameters != null) {
            parameterItems = new VWParameterItem[this.m_parameters.size()];
            this.m_parameters.copyInto(parameterItems);
        }
        return parameterItems;
    }
}

